#!/usr/local/bin/perl

if (@ARGV != 3) {
    print( "Traffic - Perl program to generate report based upon traffic.dat\n");
    print( "Arguments: <areas configuration file> <traffic base file> <result file>\n");
    die( "\n" );
}

$AreasCfgName   = $ARGV[0];
$TrafficDatName = $ARGV[1];
$ResultName     = $ARGV[2];

open( IN, $AreasCfgName ) || die("File $AreasCfgName not found.\n");

$line = <IN>;
$w    = 0;
while ($line ne "") {
    chop( $line );

    if ($line =~ s/^[Aa][Rr][Ee][Aa]\s//) {
        ($Name) = split( /\s/, $line );
        $Areas{$Name} = 1;
        if (length($Name) > $w) {
            $w = length($Name);
        }
    }
    $line = <IN>;
}

close( IN );

open( IN, $TrafficDatName ) || die("File $TrafficDatName not found.\n");

$time = <IN>;
$MaxTraffic = 0;
chop( $time );
$line = <IN>;
while ($line ne "") {
    chop( $line );

    ($Name, $Traffic) = split( /\s/, $line );
    if ($Areas{$Name} == 1) {
        $Traffic{$Name} = $Traffic;
        $Areas{$Name} = -1;
        if ($Traffic > $MaxTraffic) {
            $MaxTraffic = $Traffic;
        }
    }
    $line = <IN>;
}
close( IN );

open( OUT, ">$ResultName" ) || die( "Can't write to $ResultName\n");
print OUT ("Fileechos traffic since $time\n\n");
$dw = 78 - $w - 16;
$w = 5 if $w < 5;
$format = "%-".$w."s ";
printf OUT ( $format, "Area" );
printf OUT ( "%15s Diagram\n", "Size (bytes)" );
print OUT ("\n");
$Sum = 0;
foreach $Name (sort(keys(%Areas))) {
    printf OUT ( $format, $Name );
    if ($Areas{$Name} == -1) {
        $Traffic = $Traffic{$Name};
    }
    else {
        $Traffic = 0;
    }
    $Sum += $Traffic;
    @N = split( //, $Traffic );
    $i = @N;
    $j = 0;
    $T = "";
    while ($i > 0) {
        if ($j == 3) {
            $T = ",".$T;
            $j = 0;
        }
        $T = $N[$i-1].$T;
        $j++;
        $i--;
    }
    printf OUT ( "%15s ", $T );
    $s = "";
    $len = $Traffic * $dw / $MaxTraffic;    
    while ($len > 0) {
        $s .= "";
        $len--;
    }
    print OUT ("$s\n");
}

@N = split( //, $Sum );
$i = @N;
$j = 0;
$T = "";
while ($i > 0) {
    if ($j == 3) {
        $T = ",".$T;
        $j = 0;
    }
    $T = $N[$i-1].$T;
    $j++;
    $i--;
}

print OUT ( "\nSummary: $T byte(s)\n" );

close(OUT);

unlink( $TrafficDatName );
